<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tabla</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="assets/styles.css">
</head>
<body>
    <div class="table-container shadow-lg p-4 rounded">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3 class="p-3">Tabla de usuarios</h3>
            <a href="index.php" class="btn btn-custom">Registrar nuevo usuario</a>
        </div>
        <table class="table table-hover table-bordered">
            <thead class="table-header">
                <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Nombre</th>
                    <th scope="col">Apellido</th>
                    <th scope="col">RUT</th>
                    <th scope="col">Fecha de nacimiento</th>
                    <th scope="col">Correo</th>
                </tr>
            </thead>
            <tbody>
                <?php include "conexion.php"; $sql = $conn->query("SELECT * FROM usuarios"); while ($datos = $sql->fetch_object()) { ?>
                    <tr class="user-row" data-id="<?= $datos->id ?>" data-nombre="<?= $datos->nombre ?>" data-apellido="<?= $datos->apellido ?>" data-rut="<?= $datos->rut ?>" data-fecha="<?= $datos->fecha ?>" data-correo="<?= $datos->correo ?>">
                        <td><?= $datos->id ?></td>
                        <td><?= $datos->nombre ?></td>
                        <td><?= $datos->apellido ?></td>
                        <td><?= $datos->rut ?></td>
                        <td><?= $datos->fecha ?></td>
                        <td><?= $datos->correo ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
    <script src="assets/js.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>


