<!DOCTYPE html>
<html lang="es">

<?php include('header.php'); ?>

<body class="container">
    <div class="titulo-container d-flex justify-content-center align-items-center mt-5">
        <h1>Playlist 2024</h1>
    </div>


    <div class="d-flex align-items-center justify-content-between mt-5">
        <!-- Pestañas de Categorías -->
        <ul class="nav nav-tabs" id="categoryTabs" role="tablist">
            <li class="nav-item">
                <button class="nav-link active" id="all-tab" data-bs-toggle="tab" data-bs-target="#all" type="button"
                    role="tab" aria-controls="all" aria-selected="true">Todas</button>
            </li>
            <li class="nav-item">
                <button class="nav-link" id="album-tab" data-bs-toggle="tab" data-bs-target="#album" type="button"
                    role="tab" aria-controls="album" aria-selected="false">Álbum</button>
            </li>
            <li class="nav-item">
                <button class="nav-link" id="artist-tab" data-bs-toggle="tab" data-bs-target="#artist" type="button"
                    role="tab" aria-controls="artist" aria-selected="false">Artista</button>
            </li>
            <li class="nav-item">
                <button class="nav-link" id="chile-tab" data-bs-toggle="tab" data-bs-target="#chile" type="button"
                    role="tab" aria-controls="chile" aria-selected="false">Chile</button>
            </li>
            <li class="nav-item">
                <button class="nav-link" id="international-tab" data-bs-toggle="tab" data-bs-target="#international"
                    type="button" role="tab" aria-controls="international" aria-selected="false">Internacional</button>
            </li>
        </ul>

        <!-- Botón para mostrar el formulario -->
        <button id="showFormButton" class="btn btn-primary">Agregar Nuevo</button>
    </div>


    <!-- Formulario para agregar nueva entrada-->
    <form id="addPostForm" enctype="multipart/form-data" style="display: none;">
        <div class="mb-3">
            <label for="tipo" class="form-label">Tipo</label>
            <select id="tipo" name="tipo" class="form-select">
                <option value="artista">Artista</option>
                <option value="album">Álbum</option>
            </select>
        </div>
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" id="nombre" name="nombre" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="descripcion" class="form-label">Descripción</label>
            <textarea id="descripcion" name="descripcion" class="form-control" rows="4" required></textarea>
        </div>

        <div class="mb-3">
            <label for="imagen" class="form-label">Imagen</label>
            <input type="file" id="imagen" name="imagen" class="form-control">
            <img id="previewImagen" src="#" alt="Vista previa de la imagen"
                style="display: none; max-width: 100%; margin-top: 10px;">
        </div>

        <button type="submit" class="btn btn-primary">Agregar Entrada</button>
    </form>
    </div>

    <!-- Contenedor de Tarjetas -->
    <div id="tarjetas" class="row mt-4"></div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"></script>
    <script src="assets/js.js"></script>
</body>

</html>