<?php

if (!isset($_POST['nombre']) || !isset($_POST['descripcion'])) {
    echo json_encode(['error' => 'Faltan datos requeridos']);
    exit;
}

$title = $_POST['nombre'];
$content = $_POST['descripcion'];
$image_id = null;

if (isset($_FILES['imagen']) && $_FILES['imagen']['tmp_name']) {
    $image_file = $_FILES['imagen']['tmp_name'];
    $image_name = $_FILES['imagen']['name'];
    $mime_type = $_FILES['imagen']['type'] ?? 'application/octet-stream';

    $media_curl = curl_init();
    curl_setopt_array($media_curl, array(
        CURLOPT_URL => 'https://alagurtor.laboratoriodiseno.cl/wordpress/wp-json/wp/v2/media',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => file_get_contents($image_file),
        CURLOPT_HTTPHEADER => array(
            'Authorization: Basic YWxhbl9hZ3VydG86OUtxdiBCRWNGIFFsZWMgcEdleSBTbGFLIFVMZnA=',
            'Content-Disposition: attachment; filename="' . $image_name . '"',
            'Content-Type: ' . $mime_type
        ),
        CURLOPT_SSL_VERIFYPEER => false
    ));

    $media_response = curl_exec($media_curl);
    $media_http_code = curl_getinfo($media_curl, CURLINFO_HTTP_CODE);
    curl_close($media_curl);

    if ($media_http_code === 201) {
        $media_data = json_decode($media_response, true);
        $image_id = $media_data['id'];
    }
}

$post_data = array(
    'title' => $title,
    'content' => $content,
    'status' => 'publish',
);

if ($image_id) {
    $post_data['featured_media'] = $image_id;
}

$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://alagurtor.laboratoriodiseno.cl/wordpress/wp-json/wp/v2/posts',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($post_data),
    CURLOPT_HTTPHEADER => array(
        'Authorization: Basic YWxhbl9hZ3VydG86OUtxdiBCRWNGIFFsZWMgcEdleSBTbGFLIFVMZnA=',
        'Content-Type: application/json'
    ),
    CURLOPT_SSL_VERIFYPEER => false
));

$response = curl_exec($curl);
curl_close($curl);

echo $response;
?>
