$(document).ready(function () {
    AOS.init();

    $('#showFormButton').on('click', function () {
        $('#addPostForm').toggle();
    });

    $('#addPostForm').on('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(this);

        $.ajax({
            url: 'agregar.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function () {
                $('#addPostForm')[0].reset();
                $('#previewImagen').hide();
                cargarPosts();
            }
        });
    });

    $('#imagen').on('change', function (event) {
        const file = event.target.files[0];
        const preview = $('#previewImagen')[0];

        if (file) {
            const reader = new FileReader();
            reader.onload = function (e) {
                preview.src = e.target.result;
                preview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            preview.style.display = 'none';
        }
    });

    function cargarPosts(categoria = '') {
        $.get('get.php', function (posts) {
            posts = JSON.parse(posts);

            const tarjetasContainer = $('#tarjetas');
            tarjetasContainer.empty();

            posts.forEach(function (post) {
                if (categoria && !post.categories.includes(parseInt(categoria))) return;

                const imageUrl = post._embedded && post._embedded['wp:featuredmedia']
                    ? post._embedded['wp:featuredmedia'][0].source_url
                    : 'default-image.jpg';

                const card = `
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3 mt-3" data-aos="fade-up">
                        <div class="card" style="width: 100%;">
                            <img src="${imageUrl}" class="card-img-top" alt="${post.title.rendered}">
                            <div class="card-body">
                                <h5 class="card-title">${post.title.rendered}</h5>
                                <a href="informacion.php?title=${encodeURIComponent(post.title.rendered)}&excerpt=${encodeURIComponent(post.excerpt.rendered)}&content=${encodeURIComponent(post.content.rendered)}&imageUrl=${encodeURIComponent(imageUrl)}" target="_blank" class="btn btn-primary">Ver más</a>
                                <button class="btn btn-danger mt-2 delete-btn" data-id="${post.id}">Eliminar</button>
                            </div>
                        </div>
                    </div>
                `;
                tarjetasContainer.append(card);
            });

            AOS.refresh(); // Recargar las animaciones AOS

            // Agregar evento de eliminación
            $('.delete-btn').on('click', function () {
                const postId = $(this).data('id');
                eliminarPost(postId);
            });
        });
    }

    function eliminarPost(postId) {
        $.ajax({
            url: 'eliminar.php', //  eliminar la publicación
            type: 'POST',
            data: { id: postId },
            success: function () {
                alert('Publicación eliminada correctamente');
                cargarPosts(); // Recargar las publicaciones
            },
            error: function () {
                alert('Error al eliminar la publicación');
            }
        });
    }

    cargarPosts();

    $('#categoryTabs button').on('click', function () {
        const categoria = $(this).data('bs-target').replace('#', '');
        let categoriaId = '';

        switch (categoria) {
            case 'album': categoriaId = '35'; break;
            case 'artista': categoriaId = '38'; break;
            case 'chile': categoriaId = '36'; break;
            case 'international': categoriaId = '37'; break;
        }

        cargarPosts(categoriaId);
    });
});
